/*
 * Decompiled with CFR 0.152.
 */
package kiwiapollo.cobblemontrainerbattle.mixin;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.CobblemonSounds;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.entity.PokemonSender;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.pokemon.PokemonSentPostEvent;
import com.cobblemon.mod.common.entity.PlatformType;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.entity.pokemon.effects.IllusionEffect;
import com.cobblemon.mod.common.net.messages.client.effect.SpawnSnowstormEntityParticlePacket;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.activestate.ShoulderedState;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import kiwiapollo.cobblemontrainerbattle.battle.battleactor.PlayerBackedTrainerBattleActor;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Debug;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Debug(export=true)
@Mixin(value={Pokemon.class})
public abstract class PokemonMixin {
    @Inject(method={"sendOutWithAnimation"}, at={@At(value="HEAD")}, cancellable=true)
    public void sendOutWithAnimationForTrainerBattle(class_1309 source, class_3218 level, class_243 position, @Nullable UUID battleId, boolean doCry, @Nullable IllusionEffect illusion, Function1<PokemonEntity, Unit> mutation, CallbackInfoReturnable<CompletableFuture<PokemonEntity>> info) {
        if (this.isPlayerBackedTrainerBattle(battleId)) {
            info.setReturnValue(this.sendOutWithAnimationForPlayerBackedTrainerBattle(source, level, position, battleId, doCry, illusion, mutation));
            info.cancel();
        }
    }

    private boolean isPlayerBackedTrainerBattle(@Nullable UUID battleId) {
        try {
            PokemonBattle battle = Cobblemon.INSTANCE.getBattleRegistry().getBattle(battleId);
            return Arrays.stream(battle.getSide2().getActors()).anyMatch(actor -> actor instanceof PlayerBackedTrainerBattleActor);
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    private CompletableFuture<PokemonEntity> sendOutWithAnimationForPlayerBackedTrainerBattle(class_1309 source, class_3218 level, class_243 position, UUID battleId, boolean doCry, IllusionEffect illusion, Function1<PokemonEntity, Unit> mutation) {
        CompletableFuture preamble;
        Pokemon pokemon = (Pokemon)this;
        if (pokemon.getState() instanceof ShoulderedState) {
            return pokemon.sendOutFromShoulder((class_3222)source, level, position, battleId, doCry, illusion, mutation);
        }
        CompletableFuture<PokemonEntity> future = new CompletableFuture<PokemonEntity>();
        if (source instanceof PokemonSender) {
            PokemonSender sender = (PokemonSender)source;
            preamble = sender.sendingOut(pokemon);
        } else {
            preamble = CompletableFuture.completedFuture(Unit.INSTANCE);
        }
        preamble.thenApply(unit -> pokemon.sendOut(level, position, illusion, pokemonEntity -> {
            class_1309 owner = pokemon.getOwnerEntity();
            if (owner != null) {
                owner.method_23667(class_1268.field_5808, true);
                level.method_45445((class_1297)owner, owner.method_24515(), CobblemonSounds.POKE_BALL_THROW, class_3419.field_15248, 0.6f, 1.0f);
            }
            pokemonEntity.method_6174(pokemon.getOwnerUUID());
            pokemonEntity.setPhasingTargetId(source.method_5628());
            pokemonEntity.setBeamMode(1);
            pokemonEntity.setBattleId(battleId);
            if (pokemonEntity.getBattleId() == null) {
                pokemonEntity.setPlatform(PlatformType.NONE);
            }
            pokemonEntity.after(0.5f, () -> {
                pokemonEntity.setPhasingTargetId(-1);
                return Unit.INSTANCE;
            });
            pokemonEntity.after(1.5f, () -> {
                if (pokemonEntity.getBeamMode() == 3) {
                    future.complete((PokemonEntity)pokemonEntity);
                    return Unit.INSTANCE;
                }
                pokemonEntity.setPhasingTargetId(-1);
                pokemonEntity.setBeamMode(0);
                future.complete((PokemonEntity)pokemonEntity);
                CobblemonEvents.POKEMON_SENT_POST.post((Object[])new PokemonSentPostEvent[]{new PokemonSentPostEvent(pokemon, pokemonEntity)}, event -> Unit.INSTANCE);
                if (doCry) {
                    pokemonEntity.cry();
                }
                if (illusion != null) {
                    if (illusion.getMock().getShiny().booleanValue()) {
                        new SpawnSnowstormEntityParticlePacket(MiscUtilsKt.cobblemonResource((String)"shiny_ring"), pokemonEntity.method_5628(), List.of("shiny_particles", "middle"), null, null).sendToPlayersAround(pokemonEntity.method_23317(), pokemonEntity.method_23318(), pokemonEntity.method_23321(), 64.0, pokemonEntity.method_37908().method_27983(), serverPlayerEntity -> false);
                    }
                } else if (pokemon.getShiny()) {
                    new SpawnSnowstormEntityParticlePacket(MiscUtilsKt.cobblemonResource((String)"shiny_ring"), pokemonEntity.method_5628(), List.of("shiny_particles", "middle"), null, null).sendToPlayersAround(pokemonEntity.method_23317(), pokemonEntity.method_23318(), pokemonEntity.method_23321(), 64.0, pokemonEntity.method_37908().method_27983(), serverPlayerEntity -> false);
                }
                return Unit.INSTANCE;
            });
            mutation.invoke(pokemonEntity);
            return Unit.INSTANCE;
        }));
        return future;
    }
}

